<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sa="http://www.sa.dk/xmlns/diark/1.0">
	<xsl:output method="html" indent="yes"/>
	<xsl:template match="sa:archiveIndex">
		<html>
			<head>
				<style type="text/css">
				hr {color:sienna;}
				p {margin-left:20px; }
				body { font-family:tahoma}		
				table{background-color: #5CB3FF}
				i{color:#810541}
		</style>
				<title>ArchiveIndex</title>
			</head>
			<body>
				<h1>ArchiveIndex.xml</h1>
				<table border="2">
					<tr>
						<p>
							<td>Arkiveringsversions ID:</td>
							<td>
								<xsl:value-of select="sa:archiveInformationPackageID"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>Arkiveringsversions ID på tidlige aflevering</td>
							<td>
								<xsl:value-of select="sa:archiveInformationPackageIDPrevious"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>Arkivperiode start: </td>
							<td>
								<xsl:value-of select="sa:archivePeriodStart"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>Arkivperiode slut: </td>
							<td>
								<xsl:value-of select="sa:archivePeriodEnd"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>archiveInformationPacketType</td>
							<td>
								<xsl:value-of select="sa:archiveInformationPacketType"/>
							</td>
						</p>
					</tr>
					<tr>
						<td>
							<b>Arkiv skabere:</b>
						</td>
					</tr>
					<br/>
					<xsl:for-each select="sa:archiveCreatorList/sa:creatorName">
						<tr>
							<td>creatorName:</td>
							<td>
								<xsl:value-of select="."/>
							</td>
						</tr>
						<tr>
							<td>creationPeriodStart:</td>
							<td>
								<xsl:value-of select="//sa:creationPeriodStart"/>
							</td>
						</tr>
						<tr>
							<td>creationPeriodEnd:</td>
							<td>
								<xsl:value-of select="//sa:creationPeriodEnd"/>
							</td>
						</tr>
					</xsl:for-each>
					<tr>
						<p>
							<td>archiveType:</td>
							<td>
								<xsl:value-of select="sa:archiveType"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>systemName:</td>
							<td>
								<xsl:value-of select="sa:systemName"/>
							</td>
						</p>
					</tr>
					<tr>
						<td>
							<b>Alternative systemnavne:</b>
						</td>
					</tr>
					<tr>
					<xsl:if test="(sa:alternativeName= '')">
					<td>
								alternativeName:
							</td>							
							<td></td>
							</xsl:if>
							</tr>
						<xsl:for-each select="sa:alternativeName">
							<tr>
							<td>
								alternativeName:
							</td>							
							<td>
								<xsl:value-of select="."/>
							</td>
							</tr>
						</xsl:for-each>					
					<tr>
						<p>
							<td>systemPurpose:</td>
							<td>
								<xsl:value-of select="sa:systemPurpose"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>systemContent:</td>
							<td>
								<xsl:value-of select="sa:systemContent"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>regionNum:</td>
							<td>
								<xsl:value-of select="sa:regionNum"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>komNum:</td>
							<td>
								<xsl:value-of select="sa:komNum"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>cprNum:</td>
							<td>
								<xsl:value-of select="sa:cprNum"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>cvrNum:</td>
							<td>
								<xsl:value-of select="sa:cvrNum"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>matrikNum:</td>
							<td>
								<xsl:value-of select="sa:matrikNum"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>bbrNum:</td>
							<td>
								<xsl:value-of select="sa:bbrNum"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>whoSygKod:</td>
							<td>
								<xsl:value-of select="sa:whoSygKod"/>
							</td>
						</p>
					</tr>
					<tr>
						<td>
							<b>Data kilder</b>
						</td>
					</tr>
					<tr>
						<xsl:for-each select="sa:sourceName">
							<tr>
							<td>
								<p>sourceName:</p>
							</td>
							<td>
								<xsl:value-of select="."/>
							</td>
							</tr>
						</xsl:for-each>
					</tr>
					<tr>
						<td>
							<b>Data brugere</b>
						</td>
					</tr>
					<tr>
						<xsl:for-each select="sa:userName">
							<tr>
							<td>userName:</td>
							<td>
								<xsl:value-of select="."/>
							</td>
							</tr>
						</xsl:for-each>
					</tr>
					<tr>
						<td>
							<b>Forgænger systemer:</b>
						</td>
					</tr>
					<tr>
						<xsl:for-each select="sa:predecessorName">
							<tr>
							<td>predecessorName:</td>
							<td>
								<xsl:value-of select="."/>
							</td>
							</tr>
						</xsl:for-each>
					</tr>
					<tr>
						<td>
							<b>Form Version:</b>
						</td>
					</tr>
					<tr>
						<td>formVersion:</td>
						<td>
							<xsl:value-of select="sa:form/sa:formVersion"/>
						</td>
					</tr>
					<xsl:for-each select="sa:form/sa:classList/sa:formClass">
						<tr>
							<td>formClass:</td>
							<td>
								<xsl:value-of select="."/>
							</td>
						</tr>
						<tr>
							<td>formClassText:</td>
							<td>
								<xsl:value-of select="following-sibling::node()"/>
						  </td>
						</tr>
					</xsl:for-each>
					<tr>
						<p>
							<td>containsDigitalDocuments:</td>
							<td>
								<xsl:value-of select="sa:containsDigitalDocuments"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>searchRelatedOtherRecords:</td>
							<td>
								<xsl:value-of select="sa:searchRelatedOtherRecords"/>
							</td>
						</p>
					</tr>
					<tr>
						<xsl:for-each select="sa:relatedRecordsName">
							<tr>
							<td>
								<p>relatedRecordsName:</p>
							</td>
							<td>
								<xsl:value-of select="."/>
							</td>
							</tr>
						</xsl:for-each>
					</tr>
					<tr>
						<p>
							<td>systemFileConcept:</td>
							<td>
								<xsl:value-of select="sa:systemFileConcept"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>multipleDataCollection:</td>
							<td>
								<xsl:value-of select="sa:multipleDataCollection"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>personalDataRestrictedInfo:</td>
							<td>
								<xsl:value-of select="sa:personalDataRestrictedInfo"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>otherAccessTypeRestrictions:</td>
							<td>
								<xsl:value-of select="sa:otherAccessTypeRestrictions"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>archiveApproval:</td>
							<td>
								<xsl:value-of select="sa:archiveApproval"/>
							</td>
						</p>
					</tr>
					<tr>
						<p>
							<td>archiveRestrictions:</td>
							<td>
								<xsl:value-of select="sa:archiveRestrictions"/>
							</td>
						</p>
					</tr>
				</table>
				<br/>
				<input type="button" onClick="window.print()" value="Print" align="middle" size="3"/>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
